package ru.yandex.webmaster3.core.worker.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class VerifyWithWhoisTaskData extends WorkerTaskData {
    private final UUID verificationRecordId;
    private final long userId;

    public VerifyWithWhoisTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("verificationRecordId") UUID verificationRecordId,
            @JsonProperty("userId") long userId) {
        super(taskId, hostId);
        this.verificationRecordId = verificationRecordId;
        this.userId = userId;
    }

    VerifyWithWhoisTaskData(WebmasterHostId hostId, long userId, UUID verificationRecordId) {
        super(hostId);
        this.verificationRecordId = verificationRecordId;
        this.userId = userId;
    }

    public long getUserId() {
        return userId;
    }

    public UUID getVerificationRecordId() {
        return verificationRecordId;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.VERIFY_WITH_WHOIS;
    }

    @Override
    public String getShortDescription() {
        return "Verifies host for user with whois verified";
    }
}
