package ru.yandex.webmaster3.core.worker.task;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * Приоритет задачи для воркера
 * Created by iceflame on 07.03.17.
 *
 * @see WMC-3782
 */
public enum WorkerTaskPriority {

    HIGHEST("/HIGHEST", "highest"),
    HIGH("/HIGH", "high"),
    NORMAL("", "normal"),
    LOW("/LOW", "low");

    public static final EnumResolver<WorkerTaskPriority> R = EnumResolver.er(WorkerTaskPriority.class);

    // где должны лежать на диске задания (необходимо для совместимости со старыми)
    private String pathSuffix;
    //Очередь для передачи данных задач
    private String name;

    WorkerTaskPriority(String pathSuffix, String name) {
        this.pathSuffix = pathSuffix;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public boolean isHigher(WorkerTaskPriority that) {
        return compareTo(that) < 0;
    }

    public String getPathSuffix() {
        return pathSuffix;
    }
}
