package ru.yandex.webmaster3.core.worker.task;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author aherman
 */
public enum WorkerTaskType {
    UNKNOWN,

    RECRAWL_URL,
    CHANGE_MAIN_MIRROR,
    CHECK_SERPLINKS,
    CLEAN_OLD_HOST_SITEMAP_RELATIONS,
    FOLLOW_MORDA_REDIRECTS,
    INITIALIZE_HOST,
    MOBILE_AUDIT_FOR_URL,
    SAVE_BETA_USER_HOSTS,
    SAVE_QUERY_GROUP_HISTORY,
    TEST_404_ERRORS_ABSENCE,
    BUILD_NOTIFICATION_RECEIVERS_LIST,
    INITIALIZE_USER,
    SEND_MIRROR_CHANGE_NOTIFICATION,
    VERIFY_HOST,
    VERIFY_WITH_WHOIS,
    SYNC_VERIFICATION_STATE,
    NOTIFY_VERIFICATION_STATE,
    DOWNLOAD_SEARCH_URLS,
    DOWNLOAD_TURBO_SEARCH_URLS,
    DOWNLOAD_EXCLUDED_URLS,
    DOWNLOAD_EVENT_URLS,
    DOWNLOAD_INDEXED_URL_EVENT_SAMPLES,
    DOWNLOAD_INDEXED_URL_SAMPLES,
    DOWNLOAD_RECOMMENDED_QUERIES,
    DOWNLOAD_STATISTIC_ALL_GROUPS_ALL_INDICATORS,
    DOWNLOAD_STATISTIC_ALL_GROUPS_ONE_INDICATOR,
    DOWNLOAD_STATISTIC_SELECTED_GROUP_ALL_INDICATORS,
    DOWNLOAD_STATISTIC_ALL_QUERIES_ALL_INDICATORS,
    DOWNLOAD_STATISTIC_ALL_QUERIES_ONE_INDICATOR,
    DOWNLOAD_STATISTIC_SELECTED_QUERY_ALL_INDICATORS,
    DOWNLOAD_STATISTIC_ALL_URLS_ALL_INDICATORS,
    DOWNLOAD_STATISTIC_ALL_URLS_ONE_INDICATOR,
    DOWNLOAD_STATISTIC_SELECTED_URL_ALL_INDICATORS,
    DOWNLOAD_RIVALS_STATISTICS,
    RECRAWL_SITEMAP,
    CHECK_FOR_HOST_THREATS,
    PROCESS_DELURL_REQUEST,
    VALIDATE_TURBO_FEED,
    LOAD_TURBO_ERROR_CONTENT,
    TURBO_AUTO_ADV_VERIFICATION_MAIL,
    TEST_SEND_DISTRIBUTION_NOTIFICATION,
    IMPORT_EXPERIMENTS,
    CONFIRMATION_METRICA_APP_ID,
    MDS_EXPORT_TASK,
    USER_TAKEOUT,
    SITEMAP_ANALYZE,
    ROBOT_TXT_ANALYZE,
    ADD_FEED_PROCESSING,
    SERVER_ANSWER_ANALYZE,
    TEST_TASK,
    SEND_FEEDBACK_EMAIL,
    SEND_REVIEW_COMPLAIN_EMAIL,
    RECRAWL_URL_SAMOVAR,
    HOST_MOBILE_AUDIT,
    TURBO_ADV_FROM_BOX,
    METRIKA_COUNTER_BINDING,
    METRIKA_COUNTER_BINDING_CHANGE,
    USER_VERIFIES_HOST,
    FETCH_URLCHECK_DATA_BLOCK,

    // TODO temp
    UPDATE_HOST_GENERATION,
    MERGE_STRUCTURES_GENERATION,
    UPDATE_HOST_OWNER,
    UPDATE_HOST_SITEMAP_GENERATION,
    ;

    public static final EnumResolver<WorkerTaskType> R = EnumResolver.er(WorkerTaskType.class);
}
