package ru.yandex.webmaster3.core.worker.task.feeds;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.feeds.feed.FeedServiceType;
import ru.yandex.webmaster3.core.feeds.feed.NativeFeedType;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.core.worker.task.async.AsyncWorkerTaskData;

/**
 * @author: kravchenko99
 * DATE: 01.12.2021
 */
@Getter
public class ProcessingAddFeedTaskData extends AsyncWorkerTaskData {
    WebmasterHostId hostId;
    String url;
    List<Integer> regionsId;
    long userId;
    NativeFeedType type;
    Set<FeedServiceType> enabledServiceTypes;
    String login;
    String password;

    public ProcessingAddFeedTaskData(@JsonProperty("requestId") UUID requestId,
                                     @JsonProperty("hostId") WebmasterHostId hostId,
                                     @JsonProperty("url") String url,
                                     @JsonProperty("regionsId") List<Integer> regionsId,
                                     @JsonProperty("userId") long userId,
                                     @JsonProperty("type") NativeFeedType type,
                                     @JsonProperty("enabledServiceTypes") Set<FeedServiceType> enabledServiceTypes,
                                     @JsonProperty("login") String login,
                                     @JsonProperty("password") String password) {
        super(requestId);
        this.hostId = hostId;
        this.url = url;
        this.regionsId = regionsId;
        this.userId = userId;
        this.type = type;
        this.enabledServiceTypes = enabledServiceTypes;
        this.login = login;
        this.password = password;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.ADD_FEED_PROCESSING;
    }

    @Override
    public String getShortDescription() {
        return "add feed processing check and check url";
    }
}
