package ru.yandex.webmaster3.core.worker.task.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import lombok.Value;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WebmasterJsonModule;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

/**
 * @author: ishalaru
 * DATE: 21.08.2019
 */
@Value
public class WorkerTaskDataWrapper {
    private static final ObjectMapper OM = new ObjectMapper()
            .registerModules(new JodaModule(), new WebmasterJsonModule(false));

    @JsonProperty("taskType")
    private WorkerTaskType taskType;
    @JsonProperty("taskId")
    private String taskId;
    @JsonProperty("taskData")
    private String taskData;
    @JsonProperty("taskPriority")
    private WorkerTaskPriority taskPriority;
    @JsonProperty("initDate")
    private DateTime initDate;

    public static WorkerTaskDataWrapper fromWorkerTaskData(WorkerTaskData wtd) {
        try {
            return new WorkerTaskDataWrapper(wtd.getTaskType(), wtd.getTaskId().toString(), OM.writeValueAsString(wtd),
                    wtd.getTaskPriority(), DateTime.now());
        } catch (JsonProcessingException e) {
            throw new WebmasterException("Serializing error", new WebmasterErrorResponse.UnableToReadJsonRequestResponse(null, e), e);
        }
    }
}
