package ru.yandex.webmaster3.core.worker.task.robotstxt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.core.worker.task.async.AsyncWorkerTaskData;

import java.util.UUID;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
public class AnalyzeRobotTxtTaskData extends AsyncWorkerTaskData {
    private final String robotsTxtContent;
    private final String hostName;
    private final boolean loadOnly;
    private final String urls;

    public AnalyzeRobotTxtTaskData(@JsonProperty("requestId") UUID requestId,
                                   @JsonProperty("robotsTxtContent") String robotsTxtContent,
                                   @JsonProperty("hostName") String hostName,
                                   @JsonProperty("loadOnly") boolean loadOnly,
                                   @JsonProperty("urls") String urls) {
        super(requestId);
        this.robotsTxtContent = robotsTxtContent;
        this.hostName = hostName;
        this.urls = urls;
        this.loadOnly = loadOnly;
    }

    public String getRobotsTxtContent() {
        return robotsTxtContent;
    }

    public String getHostName() {
        return hostName;
    }

    public boolean isLoadOnly() {
        return loadOnly;
    }

    @JsonIgnore
    public String[] getUrlsAsArray() {
        if (StringUtils.isEmpty(urls)) {
            return new String[0];
        }
        return urls.split("[ \\t\\n\\f\\r]+");
    }

    public String getUrls() {
        return urls;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.ROBOT_TXT_ANALYZE;
    }

    @Override
    public String getShortDescription() {
        return "robotstxt analysis";
    }
}
