package ru.yandex.webmaster3.core.worker.task.sitemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.http.FileParameterTransfer;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.core.worker.task.async.AsyncWorkerTaskData;

import java.util.UUID;

/**
 * @author: ishalaru
 * DATE: 15.05.2019
 */
public class SitemapAnalysisTaskData extends AsyncWorkerTaskData {

    private final String sitemapText;
    private final String sitemapUrl;
    private final FileParameterTransfer sitemapFile;

    public SitemapAnalysisTaskData(@JsonProperty("requestId") UUID requestId,
                                   @JsonProperty("sitemapText") String sitemapText,
                                   @JsonProperty("sitemapUrl") String sitemapUrl,
                                   @JsonProperty("sitemapFile") FileParameterTransfer sitemapFile) {
        super(requestId);
        this.sitemapText = sitemapText;
        this.sitemapUrl = sitemapUrl;
        this.sitemapFile = sitemapFile;
    }

    public String getSitemapText() {
        return sitemapText;
    }

    public String getSitemapUrl() {
        return sitemapUrl;
    }

    public FileParameterTransfer getSitemapFile() {
        return sitemapFile;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.SITEMAP_ANALYZE;
    }

    @Override
    public String getShortDescription() {
        return "sitemap analysis";
    }
}
