package ru.yandex.webmaster3.core.worker.task.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.core.worker.task.async.AsyncWorkerTaskData;
import ru.yandex.webmaster3.core.zora.ZoraUserAgent;

import java.util.UUID;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
public class ServerResponseUtilTaskData extends AsyncWorkerTaskData {
    private final String url;
    private final String userIp;
    private final ZoraUserAgent userAgent;
    private final DateTime ifModifiedSince;

    public ServerResponseUtilTaskData(@JsonProperty("taskId") UUID taskId,
                                      @JsonProperty("url") String url,
                                      @JsonProperty("userIp") String userIp,
                                      @JsonProperty("userAgent") ZoraUserAgent userAgent,
                                      @JsonProperty("ifModifiedSince") DateTime ifModifiedSince) {
        super(taskId);
        this.url = url;
        this.userIp = userIp;
        this.userAgent = userAgent;
        this.ifModifiedSince = ifModifiedSince;
    }


    public String getUrl() {
        return url;
    }

    public String getUserIp() {
        return userIp;
    }

    public ZoraUserAgent getUserAgent() {
        return userAgent;
    }

    public DateTime getIfModifiedSince() {
        return ifModifiedSince;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.SERVER_ANSWER_ANALYZE;
    }

    @Override
    public String getShortDescription() {
        return "Server answer analyzer";
    }
}
