/*
  Copyright [2013-2014] eBay Software Foundation

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package ru.yandex.webmaster3.core.xcelite.sheet;

import ru.yandex.webmaster3.core.xcelite.writer.SheetWriter;
import ru.yandex.webmaster3.core.xcelite.writer.SimpleSheetWriter;
import org.apache.poi.ss.usermodel.Sheet;
import ru.yandex.webmaster3.core.xcelite.writer.StreamingBeanSheetWriter;

import java.io.File;

/**
 * Class description...
 *
 * @author kharel (kharel@ebay.com)
 * @creation_date Nov 9, 2013
 */
public class NotLeakingXceliteSheetImpl implements XceliteSheet {

    private final Sheet sheet;
    private final File file;

    public NotLeakingXceliteSheetImpl(Sheet sheet) {
        this(sheet, null);
    }

    public NotLeakingXceliteSheetImpl(Sheet sheet, File file) {
        this.sheet = sheet;
        this.file = file;
    }

    @Override
    public Sheet getNativeSheet() {
        return sheet;
    }

    @Override
    public File getFile() {
        return file;
    }

    @Override
    public <T> SheetWriter<T> getBeanWriter(Class<T> type) {
        return new StreamingBeanSheetWriter<>(this, type);
    }

    @Override
    public SimpleSheetWriter getSimpleWriter() {
        return new SimpleSheetWriter(this);
    }
}
