package ru.yandex.webmaster3.core.zora;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author avhaliullin
 */
public enum ZoraSourceEnum {
    webmaster_robot("webmaster_robot", ZoraUserAgent.ROBOT),
    webmaster_wm("webmaster_wm", ZoraUserAgent.WEBMASTER),
    webmaster_media("webmaster_media", ZoraUserAgent.MEDIA),
    webmaster_images("webmaster_images", ZoraUserAgent.IMAGES),
    webmaster_blogs("webmaster_blogs", ZoraUserAgent.BLOGS),
    webmaster_video("webmaster_video", ZoraUserAgent.VIDEO),
    webmaster_ir("webmaster_ir", ZoraUserAgent.RESIZER),
    webmaster_catalog("webmaster_catalog", ZoraUserAgent.CATALOG),
    webmaster_direct("webmaster_direct", ZoraUserAgent.DIRECT),
    webmaster_mirrors("webmaster_mirrors", ZoraUserAgent.MIRRORS),
    webmaster_vertis("webmaster_vertis", ZoraUserAgent.VERTICALS),
    webmaster_robot_batch("webmaster_robot_batch", ZoraUserAgent.BATCH),
    ;

    private final String sourceName;
    private final ZoraUserAgent userAgent;

    ZoraSourceEnum(String sourceName, ZoraUserAgent userAgent) {
        this.sourceName = sourceName;
        this.userAgent = userAgent;
    }

    public String getSourceName() {
        return sourceName;
    }

    public ZoraUserAgent getUserAgent() {
        return userAgent;
    }


    public static ZoraSourceEnum forUserAgent(ZoraUserAgent userAgent) {
        return Stream.of(values()).filter(src -> src.userAgent == userAgent).findFirst().orElse(null);
    }

    private static final Map<String, ZoraSourceEnum> ZORA_SOURCE_ENUM_MAP = Arrays.stream(ZoraSourceEnum.values())
            .collect(Collectors.toMap(ZoraSourceEnum::getSourceName, e -> e));

    public static ZoraSourceEnum getBySourceName(String sourceName) {
        return ZORA_SOURCE_ENUM_MAP.get(sourceName);
    }

}
