package ru.yandex.webmaster3.core.zora.data.calc;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;

/**
 * @author avhaliullin
 */
@Builder
public class ZoraCalcResult {
    @JsonProperty("Status")
    private final ZoraCalcStatusEnum status;
    @JsonProperty("ErrorStr")
    private final String errorStr;
    @JsonProperty("Result")
    private final Result result;

    public ZoraCalcResult(ZoraCalcStatusEnum status, String errorStr, Result result) {
        this.status = status;
        this.errorStr = errorStr;
        this.result = result;
    }

    public ZoraCalcStatusEnum getStatus() {
        return status;
    }

    public String getErrorStr() {
        return errorStr;
    }

    public Result getResult() {
        return result;
    }

    public static class Result {
        @JsonProperty("ConvMimeType")
        private final int convMimeType;
        @JsonProperty("Encoding")
        private final int encoding;
        @JsonProperty("Language")
        private final int language;
        @JsonProperty("ExtHttpCode")
        private final int extHttpCode;

        public Result(int convMimeType, int encoding, int language, int extHttpCode) {
            this.convMimeType = convMimeType;
            this.encoding = encoding;
            this.language = language;
            this.extHttpCode = extHttpCode;
        }

        public int getConvMimeType() {
            return convMimeType;
        }

        public int getEncoding() {
            return encoding;
        }

        public int getLanguage() {
            return language;
        }

        public int getExtHttpCode() {
            return extHttpCode;
        }
    }
}
