package ru.yandex.webmaster3.core.zora.data.calc;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.util.json.IntEnumJsonDeserializer;

/**
 * @author avhaliullin
 */
@JsonDeserialize(using = IntEnumJsonDeserializer.class)
public enum ZoraCalcStatusEnum implements IntEnum {
    CS_UNKNOWN(0),         // unknown error (or processing wasn't called)
    CS_OK(1),              // valid result was obtained
    CS_PROCFAIL(2),        // internal processing failure
    CS_TIMEOUT(3),         // processing took too long
    CS_SHUTDOWN(4),        // shutting down when request arived
    CS_NORESULT(5),        // no calc result (kwlang error probably)
    CS_MALFORMEDRESULT(6), // unreadable result returned
    CS_EMPTYRESULT(7),     // empty blob returned as calc result
    CS_TOO_LARGE(8),       // result with calc results is too large
    ;

    private final int id;

    ZoraCalcStatusEnum(int id) {
        this.id = id;
    }

    @Override
    public int value() {
        return id;
    }

    public static final IntEnumResolver<ZoraCalcStatusEnum> R = IntEnumResolver.r(ZoraCalcStatusEnum.class);
}
