package ru.yandex.webmaster3.core.zora.data.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.Duration;

/**
 * @author avhaliullin
 */
public class ZoraDuration {
    @JsonProperty("MicroSeconds")
    private final long microSeconds;

    @JsonCreator
    public ZoraDuration(long microSeconds) {
        this.microSeconds = microSeconds;
    }

    public long getMicroSeconds() {
        return microSeconds;
    }

    public static ZoraDuration fromDuration(Duration duration) {
        if (duration == null) {
            return null;
        }
        return new ZoraDuration(duration.getMillis() * 1000L);
    }
}
