package ru.yandex.webmaster3.core.zora.data.common;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.math.BigInteger;

/**
 * @author avhaliullin
 */
public class ZoraIPAddress {
    @JsonProperty("Type")
    private final ZoraIpTypeEnum type;
    @JsonProperty("Low")
    private final BigInteger low;
    @JsonProperty("High")
    private final BigInteger high;
    @JsonProperty("ScopeId")
    private final Long scopeId;

    public ZoraIPAddress(ZoraIpTypeEnum type, BigInteger low, BigInteger high, Long scopeId) {
        this.type = type;
        this.low = low;
        this.high = high;
        this.scopeId = scopeId;
    }

    public ZoraIpTypeEnum getType() {
        return type;
    }

    public BigInteger getLow() {
        return low;
    }

    public BigInteger getHigh() {
        return high;
    }

    public Long getScopeId() {
        return scopeId;
    }
}
