package ru.yandex.webmaster3.core.zora.data.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.ReadableInstant;

/**
 * @author avhaliullin
 */
public class ZoraInstant {
    @JsonProperty("MicroSeconds")
    private final long microSeconds;

    @JsonCreator
    public ZoraInstant(long microSeconds) {
        this.microSeconds = microSeconds;
    }

    public long getMicroSeconds() {
        return microSeconds;
    }

    public static ZoraInstant fromInstant(ReadableInstant instant) {
        if (instant == null) {
            return null;
        }
        return new ZoraInstant(instant.getMillis() * 1000L);
    }
}
