package ru.yandex.webmaster3.core.zora.data.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.util.json.IntEnumJsonDeserializer;

/**
 * @author avhaliullin
 */

@JsonDeserialize(using = IntEnumJsonDeserializer.class)
public enum ZoraIpTypeEnum implements IntEnum {
    Ipv4(0),
    Ipv6(1),
    Unset(9),
    ;

    private final int value;

    ZoraIpTypeEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<ZoraIpTypeEnum> R = IntEnumResolver.r(ZoraIpTypeEnum.class);
}
