package ru.yandex.webmaster3.core.zora.data.fetch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.RequiredArgsConstructor;

import ru.yandex.webmaster3.core.zora.data.common.ZoraDuration;
import ru.yandex.webmaster3.core.zora.data.redir.ZoraRedirSettings;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = @JsonCreator)
public class ZoraFetchOpts {
    @JsonProperty("RequestType")
    private final RequestType requestType;
    @JsonProperty("Url")
    private final String url;
    @JsonProperty("Freshness")
    private final ZoraDuration freshness;
    //    @JsonProperty("IgnoreRobotsTxt")
//    private final boolean ignoreRobotsTxt;
    @JsonProperty("Redir")
    private final ZoraRedirSettings redir;
    @JsonProperty("SslCertPolicy")
    private final ZoraSslCertPolicy sslCertPolicy;
    @JsonProperty("HttpHeaders")
    private final ZoraHttpHeaders httpHeaders;
    @JsonProperty("Priority")
    private final Long priority;

    public RequestType getRequestType() {
        return requestType;
    }

    public String getUrl() {
        return url;
    }

    public ZoraDuration getFreshness() {
        return freshness;
    }

//    public boolean isIgnoreRobotsTxt() {
//        return ignoreRobotsTxt;
//    }

    public ZoraRedirSettings getRedir() {
        return redir;
    }

    public ZoraHttpHeaders getHttpHeaders() {
        return httpHeaders;
    }

    public Long getPriority() {
        return priority;
    }

    public enum RequestType {
        ONLINE,
        //OFFLINE,
        USERPROXY,
    }
}
