package ru.yandex.webmaster3.core.zora.data.fetch;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.webmaster3.core.zora.data.common.ZoraDuration;
import ru.yandex.webmaster3.core.zora.data.common.ZoraIPAddress;
import ru.yandex.webmaster3.core.zora.data.common.ZoraInstant;
import ru.yandex.webmaster3.core.zora.data.response.ZoraTraceEntry;

/**
 * @author avhaliullin
 */
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@Getter
@Builder
public class ZoraFetchResult {
    @JsonProperty("Status")
    private final ZoraFetchStatusEnum status;
    @JsonProperty("ErrorStr")
    private final String errorStr;
    @JsonProperty("HttpStatus")
    private final Integer httpStatus;
    @JsonProperty("HttpResponse")
    private final byte[] httpResponse;
    @JsonProperty("RobotsTxt")
    private final byte[] robotsTxt;
    @JsonProperty("Ip")
    private final ZoraIPAddress ip;
    @JsonProperty("FetchIp")
    private final ZoraIPAddress fetchIp;
    @JsonProperty("FetchRegion")
    private final String fetchRegion;
    @JsonProperty("LastAccess")
    private final ZoraInstant lastAccess;
    @JsonProperty("CrawlDelay")
    private final ZoraDuration crawlDelay;
    @JsonProperty("FromCache")
    private final boolean fromCache;
    @JsonProperty("HasSslCertErrors")
    private final boolean hasSslCertErrors;
    @JsonProperty("SourceId")
    private final Long sourceId;
    @JsonProperty("ViolatesRobotsTxt")
    private final boolean violatesRobotsTxt;
    @JsonProperty("MimeType")
    private final Integer mimeType;
    @JsonProperty("RedirChain")
    private final List<String> redirChain;
    @JsonProperty("HttpLocation")
    private final String httpLocation;
    @JsonProperty("Trace")
    private final Trace trace;
    @JsonProperty("SslCertErrorsExplanation")
    private final String sslCertErrorsExplanation;

    public static class Trace {
        @JsonProperty("Entry")
        private final List<ZoraTraceEntry> entries;

        @JsonCreator
        public Trace(List<ZoraTraceEntry> entries) {
            this.entries = entries;
        }

        public List<ZoraTraceEntry> getEntries() {
            return entries;
        }
    }
}
