package ru.yandex.webmaster3.core.zora.data.fetch;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.util.json.IntEnumJsonDeserializer;

/**
 * @author avhaliullin
 */
@JsonDeserialize( using = IntEnumJsonDeserializer.class)
public enum ZoraFetchStatusEnum implements IntEnum {
    FS_OK(0),                                 //Ok
    FS_BAD_RESPONSE_HEADER(1000),             //Bad response header
    FS_CONNECTION_LOST(1001),                 //Connection lost
    FS_BODY_TOO_LARGE(1002),                  //Body too large
    FS_ROBOTS_TXT_DISALLOW(1003),             //robots.txt disallow
    FS_BAD_URL(1004),                         //Bad url
    FS_BAD_MIME(1005),                        //Bad mime type
    FS_DNS_FAILURE(1006),                     //Dns failure
    FS_BAD_STATUS_CODE(1007),                 //Bad status code
    FS_BAD_HEADER_STRING(1008),               //Bad header string
    FS_BAD_CHUNK(1009),                       //Bad chunk
    FS_CONNECT_FAILED(1010),                  //Connect failed
    FS_BAD_CONTENT_LENGTH(1013),              //Bad content length
    FS_BAD_ENCODING(1014),                    //Bad encoding
    FS_LENGTH_UNKNOWN(1015),                  //Length unknown
    FS_HEADER_EOF(1016),                      //Header EOF
    FS_MESSAGE_EOF(1017),                     //Message EOF
    FS_HEADER_TOO_LARGE(1020),                //Header is too large
    FS_BAD_CONTENT_ENCODING(1024),            //Bad content encoding
    FS_NO_RESOURCES(1025),                    //No resources
    FS_FETCHER_SHUTDOWN(1026),                //Fetcher shutdown
    FS_SERVER_BUSY(1028),                     //Server is busy
    FS_PROXY_REQUEST_TIME_OUT(1031),          //request timed out
    FS_PROXY_INTERNAL_ERROR(1032),            //Zora: internal server error
    FS_PROXY_NO_PROXY(1035),                  //Spider proxy no proxy alive in region
    FS_SSL_ERROR(1037),                       //Ssl library returned error
    FS_CACHED_COPY_NOT_FOUND(1038),           //Cached copy for the url is not available
    FS_TIMEDOUT_WHILE_BYTES_RECEIVING(1039),  //Timed out while bytes receiving
    FS_FETCHER_BAD_RESPONSE(1040),            //Bad response from fetcher
    FS_FETCHER_MB_ERROR(1041),                //Error communicating with fetcher
    FS_SSL_CERT_ERROR(1042),                  //Ssl certificate is untrusted
    FS_FIREWALL_REJECT(1043),                 //Rejected by fetcher firewall
    FS_GZIPERROR(2020),                       //Error unpacking http response
    FS_SCH_IP_BUSY(5100),                     //Scheduler: ip queue is too big
    FS_SCH_HOST_BUSY(5101),                   //Scheduler: host queue is too big
    FS_SCH_HOST_RENEWED_RECENTLY(5102),       //Scheduler: couldn't renew host too frequently
    FS_SCHEDULED(6000),                       //request has been scheduled for fetching
    FS_ZORACL_DUPLICATE(7000),                //Zoracl: request was discarded as duplicate
    FS_ZORACL_PRIORITIZED(7001),              //Zoracl: request was pushed out by other request with higher priority
    ;
    private final int id;

    ZoraFetchStatusEnum(int id) {
        this.id = id;
    }

    @Override
    public int value() {
        return id;
    }

    public static final IntEnumResolver<ZoraFetchStatusEnum> R = IntEnumResolver.r(ZoraFetchStatusEnum.class);
}
