package ru.yandex.webmaster3.core.zora.data.pdfetch;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.zora.data.request.ZoraParamsFormat;

/**
 * @author avhaliullin
 */
public class ZoraPDFetchOpts {
    @JsonProperty("ProcId")
    private final String procId;
    @JsonProperty("ParamsFormat")
    private final ZoraParamsFormat paramsFormat;
    @JsonProperty("Params")
    private final Params params;

    public ZoraPDFetchOpts(String procId, ZoraParamsFormat paramsFormat, Params params) {
        this.procId = procId;
        this.paramsFormat = paramsFormat;
        this.params = params;
    }

    public String getProcId() {
        return procId;
    }

    public ZoraParamsFormat getParamsFormat() {
        return paramsFormat;
    }

    public Params getParams() {
        return params;
    }

    public static class Params {
        @JsonProperty("IncludeDocHttpRespInResp")
        private final boolean includeDocHttpRespInResp;
        @JsonProperty("IncludeRobotsInResp")
        private final boolean includeRobotsInResp;

        public Params(boolean includeDocHttpRespInResp, boolean includeRobotsInResp) {
            this.includeDocHttpRespInResp = includeDocHttpRespInResp;
            this.includeRobotsInResp = includeRobotsInResp;
        }

        public boolean isIncludeDocHttpRespInResp() {
            return includeDocHttpRespInResp;
        }

        public boolean isIncludeRobotsInResp() {
            return includeRobotsInResp;
        }
    }
}
