package ru.yandex.webmaster3.core.zora.data.pdfetch;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.webmaster3.core.zora.data.response.ZoraPDFetchStatus;
import ru.yandex.webmaster3.core.zora.data.response.ZoraRawUrlFetchResponse;

/**
 * @author avhaliullin
 */
public class ZoraPDFetchResult {
    @JsonProperty("Result")
    private final Result result;
    @JsonProperty("Status")
    private final ZoraPDFetchStatus status;
    @Getter
    @JsonProperty("ErrorStr")
    private final String errorStr;

    @JsonCreator
    public ZoraPDFetchResult(Result result, ZoraPDFetchStatus status, String errorStr) {
        this.result = result;
        this.status = status;
        this.errorStr = errorStr;
    }

    public Result getResult() {
        return result;
    }

    public ZoraPDFetchStatus getStatus() {
        return status == null? ZoraPDFetchStatus.Ok : status;
    }

    public static class Result {
        @JsonProperty("Infos")
        private final List<ResultItem> infos;

        @JsonCreator
        public Result(List<ResultItem> infos) {
            this.infos = infos;
        }

        public List<ResultItem> getInfos() {
            return infos;
        }
    }

    public static class ResultItem {
        @JsonProperty("IsUrlAllowed")
        private final boolean urlAllowed;
        @JsonProperty("Doc")
        private final ZoraRawUrlFetchResponse doc;

        @JsonCreator
        public ResultItem(boolean urlAllowed, ZoraRawUrlFetchResponse doc) {
            this.urlAllowed = urlAllowed;
            this.doc = doc;
        }

        public boolean isUrlAllowed() {
            return urlAllowed;
        }

        public ZoraRawUrlFetchResponse getDoc() {
            return doc;
        }
    }
}
