package ru.yandex.webmaster3.core.zora.data.request;

import java.net.URI;
import java.net.URL;

/**
 * @author avhaliullin
 */
public interface ZoraPDFetchRequest extends ZoraRequest {

    static ZoraPDFetchRequest.Builder builder(URI url) {
        return new ZoraPDFetchRequest.Builder().url(url);
    }

    static ZoraPDFetchRequest.Builder builder(URL url) {
        return new ZoraPDFetchRequest.Builder().url(url);
    }

    static ZoraPDFetchRequest.Builder builder(String url) {
        return new ZoraPDFetchRequest.Builder().url(url);
    }

    boolean isOnline();

    class Builder extends AbstractZoraRequest.AbstractBuilder<ZoraPDFetchRequest.Builder> {
        public Builder() {
            pdFetchProcId = "SitaRobotsWiseRedirector";
        }

        public Builder includeDocument(boolean includeDocument) {
            this.includeDoc = includeDocument;
            return this;
        }

        public Builder includeRobots(boolean includeRobots) {
            this.includeRobots = includeRobots;
            return this;
        }

        @Override
        protected ZoraPDFetchRequest.Builder getSelf() {
            return this;
        }

        public ZoraPDFetchRequest build() {
            return _build();
        }
    }

}
