package ru.yandex.webmaster3.core.zora.data.request;

import java.net.URI;
import java.net.URISyntaxException;

import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.webmaster3.core.zora.ZoraSourceEnum;

/**
 * @author avhaliullin
 */
public interface ZoraRequest {
    @JsonIgnore
    String getUrl();

    @JsonIgnore
    ZoraSourceEnum getSourceEnum();

    @JsonIgnore
    default URI getUri() {
        try {
            return new URI(getUrl());
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    ;
}
