package ru.yandex.webmaster3.core.zora.data.request;

import java.net.URI;
import java.net.URL;

/**
 * @author avhaliullin
 */
public interface ZoraUrlFetchRequest extends ZoraRequest {

    static Builder builder(ZoraUrlFetchRequest request) {
        return (Builder) ((AbstractZoraRequest)request).getBuilder();
    }

    static Builder builder(URI url) {
        return new Builder().url(url);
    }

    static Builder builder(URL url) {
        return new Builder().url(url);
    }

    static Builder builder(String url) {
        return new Builder().url(url);
    }

    boolean isOnline();

    class Builder extends AbstractZoraRequest.AbstractBuilder<Builder> {
        @Override
        protected Builder getSelf() {
            return this;
        }

        public ZoraUrlFetchRequest build() {
            return _build();
        }
    }
}
