package ru.yandex.webmaster3.core.zora.data.response;

import ru.yandex.webmaster3.core.util.enums.IntEnum;

/**
 * @author avhaliullin
 */
public enum ZoraPDFetchStatus implements IntEnum {
    Unknown                          (0),
    Ok                               (10),
    Timeout                          (20), // job failed to finish in given time
    TooManyResults                   (30),
    NoResultsHasBeenReceivedFromCalc (40),
    NoUdfOutAttrInXCalcObject        (50),
    CanNotDeserializeUdfOutProto     (60),
    ThereIsNeitherNextReqNorUserResp (70),
    ShuttingDown                     (80), // pdfetch was shut down while processing request
    FetcherQueueOverflow             (90),
    CalcQueueOverflow                (100),
    Error                            (110); // see ErrStr
    ;

    private final int id;

    ZoraPDFetchStatus(int id) {
        this.id = id;
    }


    @Override
    public int value() {
        return id;
    }
}
