package ru.yandex.webmaster3.core.zora.data.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.webmaster3.core.zora.data.fetch.ZoraFetchResult;
import ru.yandex.webmaster3.core.zora.data.pdfetch.ZoraPDFetchResult;

/**
 * @author avhaliullin
 */
public class ZoraRawPDFetchResponse {
    @JsonProperty("Fetch")
    private final ShortFetchResult fetch;
    @JsonProperty("PDFetch")
    private final ZoraPDFetchResult pdFetch;
    @JsonProperty("ErrorStr")
    private final String errorStr;

    @JsonCreator
    public ZoraRawPDFetchResponse(ShortFetchResult fetch, ZoraPDFetchResult pdFetch, String errorStr) {
        this.fetch = fetch;
        this.pdFetch = pdFetch;
        this.errorStr = errorStr;
    }

    public ShortFetchResult getFetch() {
        return fetch;
    }

    public ZoraPDFetchResult getPdFetch() {
        return pdFetch;
    }

    public String getErrorStr() {
        return errorStr;
    }

    public static class ShortFetchResult {
        @JsonProperty("Trace")
        private final ZoraFetchResult.Trace trace;

        @JsonCreator
        public ShortFetchResult(ZoraFetchResult.Trace trace) {
            this.trace = trace;
        }

        public ZoraFetchResult.Trace getTrace() {
            return trace;
        }
    }
}
