package ru.yandex.webmaster3.core.zora.data.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.zora.data.calc.ZoraCalcResult;
import ru.yandex.webmaster3.core.zora.data.fetch.ZoraFetchResult;
import ru.yandex.webmaster3.core.zora.data.response.ZoraStatusEnum;

/**
 * @author avhaliullin
 */
public class ZoraRawUrlFetchResponse {
    @JsonProperty("Status")
    private final ZoraStatusEnum status;
    @JsonProperty("ErrorStr")
    private final String errorStr;
    @JsonProperty("RequestId")
    private final String requestId;
    @JsonProperty("Fetch")
    private final ZoraFetchResult fetch;
    @JsonProperty("Calc")
    private final ZoraCalcResult calc;

    @JsonCreator
    public ZoraRawUrlFetchResponse(ZoraStatusEnum status, String errorStr, String requestId, ZoraFetchResult fetch, ZoraCalcResult calc) {
        this.status = status;
        this.errorStr = errorStr;
        this.requestId = requestId;
        this.fetch = fetch;
        this.calc = calc;
    }

    public ZoraStatusEnum getStatus() {
        return status;
    }

    public String getErrorStr() {
        return errorStr;
    }

    public String getRequestId() {
        return requestId;
    }

    public ZoraFetchResult getFetch() {
        return fetch;
    }

    public ZoraCalcResult getCalc() {
        return calc;
    }

}
