package ru.yandex.webmaster3.core.zora.data.response;

import com.fasterxml.jackson.databind.JsonNode;

/**
 * @author avhaliullin
 */
public class ZoraResponseWithRaw<T> {
    private final T response;
    private final JsonNode jsonRequest;
    private final JsonNode jsonResponse;

    public ZoraResponseWithRaw(T response, JsonNode jsonRequest, JsonNode jsonResponse) {
        this.response = response;
        this.jsonRequest = jsonRequest;
        this.jsonResponse = jsonResponse;
    }

    public T getResponse() {
        return response;
    }

    public JsonNode getJsonRequest() {
        return jsonRequest;
    }

    public JsonNode getJsonResponse() {
        return jsonResponse;
    }
}
