package ru.yandex.webmaster3.core.zora.data.response;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ZoraSslCertErrorEnum {
    UNKNOWN,
    UNABLE_TO_GET_ISSUER_CERTIFICATE,
    UNABLE_TO_DECRYPT_CERTIFICATE_SIGNATURE,
    UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY,
    CERTIFICATE_SIGNATURE_FAILED,
    CERTIFICATE_NOT_YET_VALID,
    CERTIFICATE_EXPIRED,
    INVALID_NOT_BEFORE_FIELD,
    INVALID_NOT_AFTER_FIELD,
    SELF_SIGNED_CERTIFICATE,
    SELF_SIGNED_CERTIFICATE_IN_CHAIN,
    UNABLE_TO_GET_LOCAL_ISSUER_CERTIFICATE,
    UNABLE_TO_VERIFY_FIRST_CERTIFICATE,
    CERTIFICATE_REVOKED,
    INVALID_CA_CERTIFICATE,
    PATH_LENGTH_EXCEEDED,
    INVALID_PURPOSE,
    CERTIFICATE_UNTRUSTED,
    CERTIFICATE_REJECTED,
    UNSPECIFIED_ERROR,
    CERTIFICATE_BLACKLISTED,
    HOST_NAME_MISMATCH,
    NO_PEER_CERTIFICATE;

    private static final Map<String, ZoraSslCertErrorEnum> strToErrors = Arrays.stream(ZoraSslCertErrorEnum.values())
            .collect(Collectors.toMap(err -> err.name().replace("_", "").toUpperCase()
                    , Function.identity()));

    public static ZoraSslCertErrorEnum getEnumByString(String sslErrorString) {
        if (sslErrorString == null) {
            return UNKNOWN;
        }
        final String sslErrorStrUpper = sslErrorString.toUpperCase();
        return strToErrors.getOrDefault(sslErrorStrUpper, UNKNOWN);
    }

}
