package ru.yandex.webmaster3.core.zora.data.response;

/**
 * @author avhaliullin
 */
public enum ZoraStatusEnum {
    ZS_UNKNOWN(0), //unknown zora error
    ZS_OK(1), //Ok
    ZS_BAD_REQUEST(2), //Bad request
    ZS_TIMED_OUT(3), //Request execution timed out
    ZS_SHUTDOWN(4), //Zora is shutting down
    ZS_CONNECTIVITY_ERROR(5), //Communication error between zora nodes
    ZS_AUTH_ERROR(6), //Client is not authorized to use zora
    ZS_QUOTA_NO_SOURCENAME(101), //Quota: no such sourcename
    ZS_QUOTA_NO_REQTYPE(102), //Quota: sourcename isn't allowed to make requests of this type
    ZS_QUOTA_NO_IP(103), //Quota: sourcename isn't allowed to make requests of this type from this ip
    ZS_QUOTA_REQTYPE_EXCEEDED(104), //Quota: request type quota exceeded
    ZS_QUOTA_IP_EXCEEDED(105), //Quota: ip quota exceeded
    ZS_QUOTA_INTERNAL_ERROR(106), //Quota: internal error
    ZS_DNS_FAILURE(200), //DNS request failed
    ZS_DNS_QUEUE_EXCEEDED(201), //Too many slow DNS requests from this source
    ZS_LOCATE_FAILURE(202), //Failed to find a node to serve this request
    ZS_SESSION_ERROR(300), //Session error
    ;

    private final int id;

    ZoraStatusEnum(int id) {
        this.id = id;
    }

    public int getId() {
        return id;
    }
}
