package ru.yandex.webmaster3.core.zora.data.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.zora.data.common.ZoraInstant;

/**
 * @author avhaliullin
 */
public class ZoraTraceEntry {
    @JsonProperty("Instant")
    private final ZoraInstant instant;
    @JsonProperty("Component")
    private final String component;
    @JsonProperty("Host")
    private final String host;
    @JsonProperty("Message")
    private final String message;

    public ZoraTraceEntry(ZoraInstant instant, String component, String host, String message) {
        this.instant = instant;
        this.component = component;
        this.host = host;
        this.message = message;
    }

    public ZoraInstant getInstant() {
        return instant;
    }

    public String getComponent() {
        return component;
    }

    public String getHost() {
        return host;
    }

    public String getMessage() {
        return message;
    }
}
