package ru.yandex.webmaster3.core.zora.go_data.request;

import java.net.URI;

import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.With;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author kravchenko99
 * @date 10/9/21
 */

@Value
@With
@AllArgsConstructor
public class GoZoraRequest {
    @Description("Урл на который делается запрос")
    String url;
    @Description("Ходить по редиректам")
    boolean followRedirects;
    @Description("Проверять сертификаты для https")
    boolean ignoreCerts;
    @Description("Нужно ли body из response, нужно для запросов в которых body не требуется. " +
            "HEAD не подходит так как некоторые не поддерживают его," +
            " а некоторые могут отдавать не то что возвращают для GET")
    boolean needBody;

    @Description("login для Basic auth")
    String login;
    @Description("password для Basic auth")
    String password;

    public GoZoraRequest(String url, boolean followRedirects, boolean ignoreCerts, boolean needBody) {
        this.url = url;
        this.followRedirects = followRedirects;
        this.ignoreCerts = ignoreCerts;
        this.needBody = needBody;
        this.login = null;
        this.password = null;
    }

    public String getUserInfo() {
        if (login == null && password == null) {
            return null;
        }
        if (login != null && password == null) {
            return login;
        }
        return login + ":" + password;
    }

    public URI getUri() {
        return URI.create(url);
    }

    public static GoZoraRequest of(String url) {
        return new GoZoraRequest(url, false, true, true);
    }
}
