package ru.yandex.webmaster3.core.zora.go_data.response;

import java.util.Set;

import lombok.AllArgsConstructor;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;


// взяты из https://a.yandex-team.ru/arc/trunk/arcadia/robot/zora/gozora/internal/zerrors/errors.go#L17
@AllArgsConstructor
public enum GoZoraError implements IntEnum {
        INSECURE_CONNECTION (1000),
        DENIED_BY_FW (1001),
        TLS_HANDSHAKE (1002),
        TVM_AUTH_ERROR (1003),
        HOST_SPLIT (1004),
        DNS_RESOLVE (1005),
        DIAL_FAILED (1006),
        REMOTE_UPGRADE (1007),
        READ_RESPONSE (1008),
        RPS_LIMIT (1009),
        ;

        int code;
        public static final Set<GoZoraError> INTERNAL_ERRORS = Set.of(TVM_AUTH_ERROR, RPS_LIMIT);
        public static final String GO_ZORA_ERROR_HEADER_NAME = "X-Yandex-Gozora-Error-Code";


    @Override
        public int value() {
            return code;
        }
        public static final IntEnumResolver<GoZoraError> R = IntEnumResolver.r(GoZoraError.class);

        public static GoZoraError getGoZoraErrorCode(CloseableHttpResponse response) {
            Header goZoraEx = response.getFirstHeader(GO_ZORA_ERROR_HEADER_NAME);
            if (goZoraEx == null) {
                return null;
            }
            return GoZoraError.R.fromValueOrNull(Integer.parseInt(goZoraEx.getValue()));
        }
    }
