package ru.yandex.webmaster3.core.zora.go_data.response;

import java.io.IOException;
import java.nio.charset.Charset;

import javax.annotation.Nullable;

import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.http.util.TextUtils;

@Slf4j
@Value
public class GoZoraResponseFetchUrl {
    HttpResponse response;
    int httpCode;
    long responseTime;
    ContentType contentType;

    public String getMimeType() {
        return contentType != null ? contentType.getMimeType() : null;
    }

    public Charset getCharset() {
        return contentType != null ? contentType.getCharset() : null;
    }

    public GoZoraResponseFetchUrl(CloseableHttpResponse response, long responseTime, boolean needBody) {
        this.response = new BasicHttpResponse(response.getStatusLine());
        HttpEntity entity;
        if (needBody) {
            try {
                entity = new BufferedHttpEntity(response.getEntity());
                EntityUtils.consume(entity);
            } catch (IOException e) {
                entity = response.getEntity();
                log.error("Unable to parse http response", e);
            }
        } else {
            entity = new BasicHttpEntity();
        }
        this.response.setEntity(entity);
        this.response.setHeaders(response.getAllHeaders());
        this.httpCode = response.getStatusLine().getStatusCode();
        this.responseTime = responseTime;
        this.contentType = parseContentType(response);
    }

    @Nullable
    // большая часть кода взята из appache библиотеки, но там при невалидном charset кидает ошибку,
    // поэтому пришлось писать ручной парсер
    public static ContentType parseContentType(HttpResponse response) {
        ContentType contentType = null;
        if (response.getEntity() != null) {
            final Header header = response.getEntity().getContentType();
            if (header != null) {
                try {
                    HeaderElement[] elements = header.getElements();

                    String mimeType = ContentType.DEFAULT_TEXT.getMimeType();
                    Charset charset = null;
                    if (elements.length > 0) {
                        HeaderElement element = elements[0];
                        mimeType = element.getName();

                        for (final NameValuePair param : element.getParameters()) {
                            if (param.getName().equalsIgnoreCase("charset")) {
                                final String s = param.getValue();
                                if (!TextUtils.isBlank(s)) {
                                    try {
                                        charset = Charset.forName(s);
                                    } catch (final Exception ex) {
                                        log.error("Unknown charset - {}", s);
                                    }
                                }
                                break;
                            }
                        }
                    }
                    contentType = ContentType.create(mimeType, charset);
                } catch (final Exception ex) {
                    log.info("while parse content type error was occurred - {}", ex.getMessage(), ex);
                }
            }

        }
        return contentType;
    }
}
