package ru.yandex.webmaster3.core.zora.go_data.response;

import javax.annotation.Nullable;

import lombok.Value;
import org.apache.http.Header;

@Value
public class SimpleGoZoraResponse {
    public static final String LOCATION_HEADER_NAME = "Location";

    @Nullable
    String body;
    int httpCode;
    Header[] headers;

    // copy from appache httpcore HeadersGroup
    public Header getFirstHeader(final String name) {

        for (int i = 0; i < this.headers.length; i++) {
            final Header header = this.headers[i];
            if (header.getName().equalsIgnoreCase(name)) {
                return header;
            }
        }
        return null;
    }

    public String getRedirTarget() {
        Header location = getFirstHeader(LOCATION_HEADER_NAME);
        return location != null ? location.getValue() : null;
    }
}
