package ru.yandex.webmaster3.importer.http;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.importer.service.ImporterTaskRunner;

/**
 * Created by Oleg Bazdyrev on 06/10/2020.
 */
@WriteAction
@Component("/import/updateDefinitions")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class UpdateImportDefinitionsAction extends Action<UpdateImportDefinitionsAction.Request, UpdateImportDefinitionsAction.Response> {

    private final ImporterTaskRunner importerTaskRunner;

    @Override
    public Response process(Request request) throws WebmasterException {
        importerTaskRunner.updateDefinitions();
        return new Response();
    }

    public static final class Request implements ActionRequest {

    }

    public static final class Response implements ActionResponse.NormalResponse {

    }
}
