package ru.yandex.webmaster3.internal.common;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.internal.common.security.ActionInternalGrant;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;

/**
 * @author avhaliullin
 */
public abstract class InternalAction<Req extends InternalRequest, Res extends ActionResponse> extends Action<Req, Res> {
    private final InternalGrant grant;

    public InternalAction() {
        this(null);
    }

    public InternalAction(InternalGrant grant) {
        this.grant = grant;
    }

    @NotNull
    public InternalGrant getGrant() {
        if (this.grant != null) {
            return grant;
        }
        return getClass().getAnnotation(ActionInternalGrant.class).value();
    }
}
