package ru.yandex.webmaster3.internal.common.converter;

import ru.yandex.autodoc.common.doc.types.ValueType;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ParameterConverter;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.internal.common.data.HostAddress;

import java.lang.reflect.Type;

/**
 * @author avhaliullin
 */
public class HostAddressConverter implements ParameterConverter {
    @Override
    public ValueType describeType(Type type) {
        return TYPE;
    }

    @Override
    public Object convert(String value, Type toType) {
        try {
            WebmasterHostId hostId = IdUtils.urlToHostId(value);
            return new HostAddress(hostId, value);
        } catch (Exception e) {
            throw new IllegalArgumentException("Invalid host address: \"" + value + "\"", e);
        }
    }

    private static final ValueType TYPE = new ValueType("Host URL", ValueType.STRING);
}
