package ru.yandex.webmaster3.internal.common.error;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;

/**
 * @author avhaliullin
 */
public abstract class AbstractErrorResponse implements ActionResponse.ErrorResponse {
    private final String message;
    private final Enum<?> code;
    private final WebmasterCommonErrorSystem system;

    public AbstractErrorResponse(WebmasterCommonErrorSystem system, Enum<?> code, String message) {
        this.message = message;
        this.code = code;
        this.system = system;
    }

    @Override
    public ActionStatus getRequestStatus() {
        return ActionStatus.FAIL;
    }

    @Override
    public Enum<?> getCode() {
        return code;
    }

    @Override
    public WebmasterCommonErrorSystem getSubsystem() {
        return system;
    }

    @Override
    public Class<?> getClazz() {
        return null;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public String getStackTrace() {
        return null;
    }
}
