package ru.yandex.webmaster3.internal.common.filter;

/**
 * Created by leonidrom on 15/06/2017.
 */

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.params.ParamDescriptor;
import ru.yandex.webmaster3.core.data.UserAddedHost;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.http.RequestFilter;
import ru.yandex.webmaster3.core.http.filter.HostIsAddedByUserFilterResponse;
import ru.yandex.webmaster3.core.http.request.AddedHostIdAware;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.core.http.request.WebmasterHostIdConverter;
import ru.yandex.webmaster3.storage.user.UserUnverifiedHost;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;

import java.util.Collections;

/**
 * Копия класса из webmaster3-viewer. Необходимость копии вызвана тем, что фильтр использует
 * классы webmaster3-storage, поэтому его нельзя положить в webmaster3-core.
 */
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class HostIsAddedByUserFilter implements RequestFilter<AddedHostIdAware, HostIsAddedByUserFilterResponse> {
    private final UserHostsService userHostsService;

    @Override
    public HostIsAddedByUserFilterResponse beforeRequest(RequestContext ctx, AddedHostIdAware req) {
        WebmasterHostId hostId = req.getHostId();
        WebmasterUser user = req.getWebmasterUser();
        UserAddedHost userAddedHost;
        UserVerifiedHost userVerifiedHost = userHostsService.getVerifiedHost(user, hostId);
        if (userVerifiedHost == null) {
            UserUnverifiedHost unverifiedHost = userHostsService.getUnverifiedHost(user, hostId);
            if (unverifiedHost == null) {
                return new HostIsAddedByUserFilterResponse.HostNotAdded(this.getClass(), hostId);
            } else {
                userAddedHost = new UserAddedHost(hostId, unverifiedHost.getVerificationUin(), false);
            }
        } else {
            userAddedHost = new UserAddedHost(hostId, userVerifiedHost.getVerificationUin(), true);
        }
        req.setUserAddedHost(userAddedHost);
        return null;
    }

    @Override
    public ParamDescriptor clarifyParameter(ParamDescriptor param) {
        if (param.getName().equals("hostId")) {
            return new ParamDescriptor(param.getName(), true, WebmasterHostIdConverter.PARAM_TYPE, null,
                    "добавленный пользователем хост", Collections.emptyList());
        } else {
            return param;
        }
    }
}

