package ru.yandex.webmaster3.internal.common.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.internal.common.error.AbstractErrorResponse;

/**
 * @author avhaliullin
 */
public interface InternalAPISecurityFilterResponse extends ActionResponse.ErrorResponse {
    enum Code {
        SECURITY_INVALID_TIKET,
        SECURITY_NOT_AUTHORIZED,
    }

    @Description("Авторизационный токен отсутствует или невалидный")
    class InvalidTiket extends AbstractErrorResponse implements InternalAPISecurityFilterResponse {
        public InvalidTiket(String message) {
            super(WebmasterCommonErrorSystem.REQUEST, Code.SECURITY_INVALID_TIKET, message);
        }
    }

    @Description("У клиента нет грантов на запрошенное действие")
    class NotAuthorized extends AbstractErrorResponse implements InternalAPISecurityFilterResponse {
        public NotAuthorized(String message) {
            super(WebmasterCommonErrorSystem.REQUEST, Code.SECURITY_NOT_AUTHORIZED, message);
        }
    }
}
