package ru.yandex.webmaster3.internal.common.filter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterCommonErrorSystem;
import ru.yandex.webmaster3.internal.common.error.AbstractErrorResponse;

/**
 * @author avhaliullin
 */
public interface UserSecurityFilterResponse extends ActionResponse.ErrorResponse {
    enum Codes {
        SECURITY_USER_TICKET_REQUIRED,
        SECURITY_USER_TICKET_INVALID,
    }

    @Description("Для выполнения этого действия от имени пользователя нужен пользовательский tvm тикет, либо расширенный грант для совершения offline-операций")
    class UserTicketRequired extends AbstractErrorResponse implements UserSecurityFilterResponse {
        public UserTicketRequired() {
            super(WebmasterCommonErrorSystem.REQUEST, Codes.SECURITY_USER_TICKET_REQUIRED, "User ticket required for this action, either offline grant");
        }
    }

    @Description("Пользовательский тикет не прошел валидацию")
    class UserTicketInvalid extends AbstractErrorResponse implements UserSecurityFilterResponse {
        public UserTicketInvalid(String message) {
            super(WebmasterCommonErrorSystem.REQUEST, Codes.SECURITY_USER_TICKET_INVALID, message);
        }
    }
}
