package ru.yandex.webmaster3.internal.common.request;

import ru.yandex.webmaster3.core.data.UserAddedHost;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.request.AddedHostIdAware;

/**
 * Created by leonidrom on 14/06/2017.
 */
public class AbstractUserAddedHostRequest extends AbstractUserRequest implements AddedHostIdAware {
    private String hostIdString;
    private WebmasterHostId hostId;
    private UserAddedHost userAddedHost;

    @Override
    public void setHostId(String hostId) {
        this.hostIdString = hostId;
    }

    @Override
    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public void setConvertedHostId(WebmasterHostId hostId) {
        this.hostId = hostId;
    }

    @Override
    public String getHostIdString() {
        return hostIdString;
    }

    @Override
    public UserAddedHost getUserAddedHost() {
        return userAddedHost;
    }

    @Override
    public void setUserAddedHost(UserAddedHost userAddedHost) {
        this.userAddedHost = userAddedHost;
    }
}

