package ru.yandex.webmaster3.internal.common.request;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.request.VerifiedHostIdAware;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;

/**
 * User: azakharov
 * Date: 27.08.14
 * Time: 17:52
 */
public abstract class AbstractUserVerifiedHostRequest extends AbstractUserRequest implements VerifiedHostIdAware {
    private String hostIdString;
    private WebmasterHostId hostId;
    private UserVerifiedHost userVerifiedHost;

    @Override
    public void setHostId(String hostId) {
        this.hostIdString = hostId;
    }

    @Override
    public WebmasterHostId getHostId() {
        return hostId;
    }

    @Override
    public void setConvertedHostId(WebmasterHostId hostId) {
        this.hostId = hostId;
    }

    @Override
    public String getHostIdString() {
        return hostIdString;
    }

    @Override
    public UserVerifiedHost getUserVerifiedHost() {
        return userVerifiedHost;
    }

    @Override
    public void setUserVerifiedHost(UserVerifiedHost userVerifiedHost) {
        this.userVerifiedHost = userVerifiedHost;
    }
}
