package ru.yandex.webmaster3.internal.common.security.dao;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.util.W3Collectors;
import ru.yandex.webmaster3.internal.common.security.InternalClient;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.internal.common.security.InternalGrantOptions;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.Select;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


/**
 * @author kravchenko99
 * @date 11/25/20
 */

@Repository
public class InternalApiClientsYDao extends AbstractYDao {
    private static final InternalGrantOptions COMPAT_DEFAULT_GRANT_OPTS = new InternalGrantOptions(true);

    private static final String TABLE_NAME = "internal_api_clients";

    public InternalApiClientsYDao() {
        super(PREFIX_INTERNAL, TABLE_NAME);
    }

    public InternalClient getClient(int clientId) {
        final Select.Where where = select(MAPPER)
                .where(F.CLIENT_ID.eq(clientId));
        return queryOne(where.getStatement(), MAPPER);
    }

    public List<InternalClient> getAllInternalClients() {
        return queryForList(select(MAPPER), MAPPER);
    }

    private final static DataMapper<InternalClient> MAPPER = DataMapper.create(
            F.CLIENT_ID, F.NAME, F.SHORT_NAME, F.GRANTS, F.GRANTS2,
            (clientId, name, shortName, grants, grants2) -> {
                if (grants2 == null || grants2.isEmpty()) {
                    grants2 = grants.stream().map(g -> Pair.of(g, COMPAT_DEFAULT_GRANT_OPTS)).collect(W3Collectors.toEnumMap(InternalGrant.class));
                }
                return new InternalClient(clientId, name, shortName, grants2);
            }
    );

    private interface F {
        TypeReference<Set<InternalGrant>> GRANTS_REFERENCE = new TypeReference<>() {
        };

        TypeReference<Map<InternalGrant, InternalGrantOptions>> GRANTS2_REFERENCE = new TypeReference<>() {
        };

        Field<Integer> CLIENT_ID = Fields.intField("client_id");
        Field<String> NAME = Fields.stringField("name");
        Field<String> SHORT_NAME = Fields.stringField("short_name");
        Field<Set<InternalGrant>> GRANTS = Fields.setField("grants", GRANTS_REFERENCE).makeOptional();
        Field<Map<InternalGrant, InternalGrantOptions>> GRANTS2 = Fields.mapField("grants2", GRANTS2_REFERENCE).makeOptional();
    }
}
