package ru.yandex.webmaster3.internal.feeds.data;

import lombok.AllArgsConstructor;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * @author kravchenko99
 * @date 10/12/21
 */

@AllArgsConstructor
public enum FeedsErrors {
    @Description("Фид который регистрируется в mbi, не допускаются операции изменения статусов")
    MBI_FEED,
    @Description("Фида нет в Вебмастере либо он был удален")
    FEED_DOESNT_EXISTS,
    @Description("Фид уже добавлен в вебмастере")
    FEED_ALREDY_ADDED,
    @Description("Нет комментария")
    NO_COMMENT,
    @Description("Поддерживается только https протокол")
    HTTPS_ERROR,
    @Description("Некорректный формат урла")
    URL_ERROR,
    @Description("Некорректный регион")
    REGION_ERROR,
    ;
}
