package ru.yandex.webmaster3.internal.metrika.counter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

/**
 * Created by ifilippov5 on 24.10.17.
 */
public abstract class MetrikaBindingResponse implements ActionResponse {
    private final boolean success;
    private final String status;

    public MetrikaBindingResponse(boolean success, String status) {
        this.success = success;
        this.status = status;
    }

    public boolean isSuccess() {
        return success;
    }

    public String getStatus() {
        return status;
    }

    public static class NormalResponse extends MetrikaBindingResponse implements ActionResponse.NormalResponse {
        public NormalResponse(String status) {
            super(true, status);
        }
    }

    public enum Errors {
        INCONSISTENT_COUNTER_STATE,
        INVALID_DOMAIN,
    }

    public abstract static class ErrorResponse extends MetrikaBindingResponse implements ActionResponse.NormalResponse {
        private final Errors errorCode;

        public ErrorResponse(Errors code, String status) {
            super(false, status);
            this.errorCode = code;
        }

        public Errors getErrorCode() {
            return errorCode;
        }
    }

    @Description("Запрос не соответствует текущему состоянию счетчика")
    public static class InconsistentCounterStateError extends ErrorResponse {
        public InconsistentCounterStateError(String status) {
            super(Errors.INCONSISTENT_COUNTER_STATE, status);
        }
    }

    @Description("Невалидный домен")
    public static class InvalidDomainError extends ErrorResponse {
        public InvalidDomainError() {
            super(Errors.INVALID_DOMAIN, "");
        }
    }
}
