package ru.yandex.webmaster3.internal.searchbase;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.searchbase.SearchBaseUpdateInfo;
import ru.yandex.webmaster3.internal.common.InternalAction;
import ru.yandex.webmaster3.internal.common.security.InternalGrant;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.searchbase.dao.SearchBaseUpdatesYDao;

/**
 * @author avhaliullin
 */
@Description("Узнать даты сборки и переключения последней поисковой базы")
@ReadAction
public class LatestSearchBaseUpdateAction extends InternalAction<LatestSearchBaseUpdateRequest, LatestSearchBaseUpdateResponse> {
    private SearchBaseUpdatesYDao searchBaseUpdatesYDao;

    public LatestSearchBaseUpdateAction() {
        super(InternalGrant.SEARCH_BASE);
    }

    @Override
    public LatestSearchBaseUpdateResponse process(LatestSearchBaseUpdateRequest request) throws WebmasterException {
        try {
            SearchBaseUpdateInfo updateInfo = searchBaseUpdatesYDao.getUpdatesHistory().lastEntry().getValue();
            return new LatestSearchBaseUpdateResponse(updateInfo.getBaseSwitchDate(), updateInfo.getBaseCollectionDate());
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Failed to get latest search base update info",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    @Required
    public void setSearchBaseUpdatesYDao(SearchBaseUpdatesYDao searchBaseUpdatesYDao) {
        this.searchBaseUpdatesYDao = searchBaseUpdatesYDao;
    }
}
