package ru.yandex.webmaster3.internal.searchbase;

import org.joda.time.Instant;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public class LatestSearchBaseUpdateResponse implements ActionResponse {
    private final Instant switchDate;
    private final Instant collectDate;

    public LatestSearchBaseUpdateResponse(Instant switchDate, Instant collectDate) {
        this.switchDate = switchDate;
        this.collectDate = collectDate;
    }

    @Description("Дата переключения базы (обнаружения факта переключения на стороне вебмастера)")
    public Instant getSwitchDate() {
        return switchDate;
    }

    @Description("Дата сборки базы")
    public Instant getCollectDate() {
        return collectDate;
    }

    @Override
    public ActionStatus getRequestStatus() {
        return ActionStatus.SUCCESS;
    }
}
