package ru.yandex.webmaster3.internal.turbo;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings.TurboHostSettingsBuilder;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.internal.turbo.SetTurboHostCssAction.Request;
import ru.yandex.webmaster3.internal.turbo.SetTurboHostCssAction.Response;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.turbo.service.settings.TurboSettingsService;
import ru.yandex.webmaster3.storage.turbo.service.preview.TurboFeedPreviewService;

/**
 * TODO костыльная временная ручка для установки css для хоста
 * Created by Oleg Bazdyrev on 28/04/2018.
 */
@WriteAction
@Description("TODO костыльная временная ручка для установки css для хоста")
@Category("turbo")
public class SetTurboHostCssAction extends Action<Request, Response> {

    private TurboSettingsService turboSettingsService;
    private TurboFeedPreviewService turboFeedPreviewService;

    @Override
    public Response process(Request request) throws WebmasterException {
        try {
            WebmasterHostId hostId = IdUtils.stringToHostId(request.hostId);
            TurboHostSettingsBuilder builder = new TurboHostSettingsBuilder(turboSettingsService.getSettings(hostId));
            // set css
            builder = builder.setCss(request.css, request.css);
            // save to cs
            TurboHostSettings settings = builder.build();
            turboSettingsService.updateSettings(hostId, settings);
            // realtime update
            turboFeedPreviewService.uploadHostSettings(hostId, settings, null, null, false);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Cassandra error",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
        return new Response();
    }

    @Required
    public void setTurboSettingsService(TurboSettingsService turboSettingsService) {
        this.turboSettingsService = turboSettingsService;
    }

    @Required
    public void setTurboFeedPreviewService(TurboFeedPreviewService turboFeedPreviewService) {
        this.turboFeedPreviewService = turboFeedPreviewService;
    }

    public static final class Request implements ActionRequest {

        private String hostId;
        private String css;

        public String getHostId() {
            return hostId;
        }

        @RequestQueryProperty(required = true)
        public void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public String getCss() {
            return css;
        }

        @RequestQueryProperty
        @Description("Искомый css")
        public void setCss(String css) {
            this.css = css;
        }
    }

    public static final class Response implements ActionResponse.NormalResponse {

    }

}
